/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.worldgen.trees.mangrove;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import teamdraco.unnamedanimalmod.common.worldgen.trees.mangrove.Entry;
import teamdraco.unnamedanimalmod.common.worldgen.trees.mangrove.MangroveTreeHelper;
import teamdraco.unnamedanimalmod.init.UAMBlocks;

public class MangroveWaterTreeFeature
extends Feature<NoFeatureConfig> {
    public MangroveWaterTreeFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!reader.func_201671_F(pos)) {
            return false;
        }
        BlockState defaultLog = ((Block)UAMBlocks.MANGROVE_LOG.get()).func_176223_P();
        ArrayList<Entry> filler = new ArrayList<Entry>();
        ArrayList<Entry> leavesFiller = new ArrayList<Entry>();
        int waterSurface = 0;
        int worldOffset = reader.func_217301_I() - pos.func_177956_o();
        for (int i = 0; i <= worldOffset; ++i) {
            if (reader.func_201671_F(pos.func_177981_b(i))) continue;
            waterSurface = Math.max(MangroveTreeHelper.minimumWaterTrunkOffset, i);
            break;
        }
        int trunkHeight = MangroveTreeHelper.minimumWaterTrunkHeight + rand.nextInt(MangroveTreeHelper.waterTrunkHeightExtra + 1);
        BlockPos trunkStart = pos.func_177981_b(waterSurface + rand.nextInt(MangroveTreeHelper.waterTrunkOffsetExtra + 1));
        BlockPos trunkTop = trunkStart.func_177981_b(trunkHeight);
        for (int i = 0; i <= trunkHeight; ++i) {
            BlockPos trunkPos = trunkStart.func_177981_b(i);
            if (!MangroveTreeHelper.canPlace(reader, trunkPos)) {
                return false;
            }
            filler.add(new Entry(trunkPos, defaultLog));
        }
        MangroveTreeHelper.makeLeafBlob(leavesFiller, rand, trunkStart, trunkHeight);
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        Direction lowestDirection = directions[rand.nextInt(directions.length)];
        for (Direction direction : directions) {
            BlockPos rootPos;
            int i;
            int rootHeight = rand.nextInt(MangroveTreeHelper.maximumUpwardsWaterRootOffset + 1);
            if (direction.equals((Object)lowestDirection)) {
                rootHeight = 0;
            }
            int rootOffset = MangroveTreeHelper.minimumWaterRootCoreOffset + rand.nextInt(MangroveTreeHelper.waterRootCoreOffsetExtra + 1);
            BlockPos rootStartPos = trunkStart.func_177981_b(rootHeight).func_177967_a(direction, rootOffset);
            for (i = 0; i < rootOffset; ++i) {
                BlockPos rootConnectionPos = rootStartPos.func_177967_a(direction.func_176734_d(), i);
                if (!MangroveTreeHelper.canPlace(reader, rootConnectionPos)) {
                    return false;
                }
                filler.add(new Entry(rootConnectionPos, (BlockState)defaultLog.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k())));
            }
            i = 0;
            while (MangroveTreeHelper.canPlace(reader, rootPos = rootStartPos.func_177979_c(i))) {
                filler.add(new Entry(rootPos, defaultLog));
                ++i;
            }
        }
        Direction highestDirection = directions[rand.nextInt(directions.length)];
        boolean failed = false;
        for (Direction direction : directions) {
            int branchCoreOffset = rand.nextInt(MangroveTreeHelper.maximumDownwardsBranchOffset + 1);
            if (direction.equals((Object)highestDirection)) {
                branchCoreOffset = 0;
            } else if (!failed && (double)rand.nextFloat() < 0.25) {
                failed = true;
                continue;
            }
            int branchOffset = MangroveTreeHelper.minimumBranchCoreOffset + rand.nextInt(MangroveTreeHelper.branchCoreOffsetExtra + 1);
            BlockPos branchStartPos = trunkTop.func_177979_c(branchCoreOffset).func_177967_a(direction, branchOffset);
            for (int i = 0; i < branchOffset; ++i) {
                BlockPos branchConnectionPos = branchStartPos.func_177967_a(direction.func_176734_d(), i);
                if (!MangroveTreeHelper.canPlace(reader, branchConnectionPos)) {
                    return false;
                }
                filler.add(new Entry(branchConnectionPos, (BlockState)defaultLog.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k())));
            }
            int branchHeight = MangroveTreeHelper.minimumBranchHeight + rand.nextInt(MangroveTreeHelper.branchHeightExtra + 1);
            for (int i = 0; i <= branchHeight; ++i) {
                BlockPos branchPos = branchStartPos.func_177981_b(i);
                if (!MangroveTreeHelper.canPlace(reader, branchPos)) {
                    return false;
                }
                filler.add(new Entry(branchPos, defaultLog));
            }
            MangroveTreeHelper.makeLeafBlob(leavesFiller, rand, branchStartPos, branchHeight);
        }
        filler.add(new Entry(pos, Blocks.field_150355_j.func_176223_P()));
        MangroveTreeHelper.fill(reader, filler);
        MangroveTreeHelper.fillLeaves(reader, rand, leavesFiller);
        return true;
    }
}

